<?php
/****************************************
 * XKLog 公用包含文件
 *
 * 此文件非常重要，所有前台页面都要包含调用此文件。
 * 此文件建立 XKLog 运行环境，并载入内核文件。
 * 大多数情况下，XKLog 从这里开始执行。
 *
 * 更新：2009-4-19
 * 版本：V1.0
 ****************************************/

// 调试时将参数 report_level 设置为 E_ALL，发布时设置为 0
error_reporting(E_ALL);
set_magic_quotes_runtime(0);
function_exists('date_default_timezone_set') && date_default_timezone_set('Etc/GMT-8');

// 清除不需要的变量
$defined_vars = get_defined_vars();
foreach ( $defined_vars as $ikey => $ivalue ) {
	if (!in_array($ikey,array('GLOBALS','_POST','_GET','_COOKIE','_SERVER','_FILES'))) {
		${$ikey} = '';
		unset(${$ikey});
	}
}
unset($defined_vars);

// 开始运行时刻
$mtime = explode(' ',microtime());
$start_time = $mtime[0] + $mtime[1];

define('IN_XKLOG',true);
define('XKLOG_ROOT',str_replace('\\','/',substr(dirname(__FILE__),0,-13)));
define('PHP_TIME',time());

// 载入配置、系统函数库
require( XKLOG_ROOT . './include/config.php' );
require( XKLOG_ROOT . './include/version.php' );
require( XKLOG_ROOT . './function/class_mysql.php' );
require( XKLOG_ROOT . './function/fun_global.php' );
require( XKLOG_ROOT . './function/fun_cache.php' );
require( XKLOG_ROOT . './function/fun_show.php' );
require( XKLOG_ROOT . './function/fun_safe.php' );

if ( !get_magic_quotes_gpc() ) {
	$_GET = add_slashes($_GET);
	$_POST = add_slashes($_POST);
	$_COOKIE = add_slashes($_COOKIE);
}
$_FILES = add_slashes($_FILES);

// 开启用户会话
session_start();

// ……
obstart();

// 打开数据库连接
$db = new mysql();
$db->connect(DB_HOST, DB_USER, DB_PWD, DB_NAME, DB_PCONNECT);

// 建立缓存
$_CACHE = array();
$_ENV = array();
//cache_initialize();
$cache_list = array( 'set','category','article_new','article_hot','comment_new','guestbook_new','link','menu','count',/*'plugin'*/'tag' );
foreach ( $cache_list as $cache ){
	$cache_name = XKLOG_ROOT . './cache/cache_' . $cache . '.php';
	include_once( $cache_name );
}
unset($cache_list,$cache,$cache_name);

// 在线人数统计
//$_CACHE['count'][0]['Online'] = cache_online();

// 判断是否开放博客
// $_CACHE['set'][0]['Enable'] = 0;
//if( $_CACHE['set'][0]['Enable'] == 0 ){
//	show_message( $_CACHE['set'][0]['CloseReason'] );
//	exit;
//}

// 判断在线人数是否达到上限
// $_CACHE['set'][0]['Online'] = 101;
//if( $_CACHE['count'][0]['Online'] > $_CACHE['set'][0]['MaxOnline'] ){
//	show_message( '在线人数已达上限，请稍后访问' );
//	exit;
//}

// 设置 Cookie
if( !isset( $_COOKIE[ PREFIX_STR . 'UserName' ] ) ){
	$blog_path = str_replace( ' ','%20', BLOG_PATH );
	setcookie( PREFIX_STR . 'Visit', 'Yes', PHP_TIME + 31536000,$blog_path);
	setcookie( PREFIX_STR . 'UserName', 'Guest', PHP_TIME + 31536000,$blog_path);
	setcookie( PREFIX_STR . 'PassWord', '0', PHP_TIME + 31536000,$blog_path);
	setcookie( PREFIX_STR . 'LastAction', PHP_TIME, PHP_TIME + 31536000,$blog_path);
	setcookie( PREFIX_STR . 'SafeNum', 0, PHP_TIME + 31536000,$blog_path);
	$_COOKIE[ PREFIX_STR . 'Visit' ] = 'Yes';
	$_COOKIE[ PREFIX_STR . 'UserName' ] = 'Guest';
	$_COOKIE[ PREFIX_STR . 'PassWord' ] = '0';
	$_COOKIE[ PREFIX_STR . 'LastAction' ] = PHP_TIME;
	$_COOKIE[ PREFIX_STR . 'SafeNum' ] = 0;
}

// 判断是否被禁止访问
//if( $_COOKIE[ PREFIX_STR . 'Visit' ] == 'No' ){
//	show_message( '您已经被禁止访问本博客' );
//	exit;
//}

// 尝试登录
$_CACHE['user']['user_name'] = '';
$_CACHE['user']['user_group'] = 0;
if( $_COOKIE[ PREFIX_STR . 'UserName' ] <> '' && $_COOKIE[ PREFIX_STR . 'PassWord' ] <> '0' ){
	$user_group = $db->result( "select `Group` from `" . PREFIX_STR . "User` where UserName='" . $_COOKIE[ PREFIX_STR . 'UserName' ] . "' And PassWord='" . $_COOKIE[ PREFIX_STR . 'PassWord' ] . "' And IsDel = 0" );
	if( $user_group == '' ){
		setcookie( PREFIX_STR . 'UserName', 'Guest', PHP_TIME + 31536000);
		setcookie( PREFIX_STR . 'PassWord', '', PHP_TIME + 31536000);
	} else {
		$_CACHE['user']['user_name'] = $_COOKIE[ PREFIX_STR . 'UserName' ];
		$_CACHE['user']['user_group'] = $user_group;
	}
}

// 读取随机文章
//$sql = 'select ID,Title,Type,Address,Category from `' . PREFIX_STR . 'Article` where IsDel=False order by rand() limit 0,6';
//$query = $db->query($sql);
//while ( $row = $db->fetch_array($query) ) {
//	$_CACHE['article_rnd'][] = $row;
//}
?>